# Summary over all benchmark Domains

## Specific Domains

#### Blocks
- **Modifications:**
    - Single Goal: p04 - p06
- **Notes:**
    - Accidental Complexity: One goal state was a dead end, as the hand isn't set as empty even tough all blocks are placed. Four other goal states were dead ends as well, as the uppermost block has to be clear in order to be removed. 
    - In the worst case, the initial goals add 5 more expansions, just to be declared dead ends. In the best case, they are being ignored. 

#### Depot
- **Modifications:**  
    - Single Goal: p01-p03
- **Notes:**
    - Setting a single goal state only marginally changes the number of expansions, due to the fact that most goal states were unfavorable anyway. Exception being with blind heuristic, as we do not recognize promising states there.
    - Accidental Complexity: Most initial goals could be avoided with a more thourough problem description, without adding new information. 
    - Essential Complexity: A minority of initial goals are created by us not knowing where the truck has to be in the end. 
    - Actions are invertible, which is nice.

#### Driverlog
- **Modifications:**
    - Single Goal: p01-p11 (p08 and p09 are not tested.)
    - Changed an action in the domain to be unambiguous. Preventing the creation of illegal actions.
    - I introduced a pathological example. By not checking if the truck is empty or full respectively when boarding and embarking, we create alternative path. 
- **Notes:**
    - The domain has a bad backward heuristic estimation. Making bidirecitonal search inefficient.
    - Accidental Complexity: Some actions are not expected to be inverted, thus are ambigously defined.
    - Essential Complexity: Some initial goals are making problems as they enable parallel expansions of similar states, which are only recognized at the very end. This makes the search very inefficient.

#### Elevators-opt11-strips
- **Modifications:**
    - Single Goal: p01-p05
- **Notes:**
    - Removing the fake goals leads to a vast improvement, NBS(lmcut) outperforms A\*(lmcut) on approximately half the problems.

#### Ged-opt14-strips

- **Modifications:**
    - Single Goal: whole domain
- **Notes:**
    - Pathological Domain! Worst case example. Path found is longer but same cost. 
    - Remarkable improvement with single goal. Equal to A\*.
    - Nearly all problems don't have a changed behaviour with only a single goal.

#### Gripper

- **Modifications:**
    - Single Goal: prob01-prob06
- **Notes:**
    - Nearly no difference with single goal, due to only one less state which is instantly recognized as longer way and thus discarded.

#### Hiking-opt14-strips 

- **Modifications:**
    - Single Goal: ptesting-1-2-3 - ptesting-1-2-5
- **Notes:**
    - Strong improvement with single goal, especially for NBS(blind).

#### Logistics00

- **Modifications:**
    - Single Goal: p04 - p06
- **Notes:** 
    - Essential Complexitiy: All initial goals stem from a lack of information. Thus, setting the initial state is adding information, even though being trivial information. 

#### Maintenance-opt14-adl

- **Modifications:**
    - Single Goal: all three 010-010. 
- **Notes:**
    - Adding a single goal can be seen as \*cheating\*. It improves the search a lot, but is still much worse.

#### Miconic

- **Modifications:**
    - Single Goal: s1-0 - s3-4 
- **Notes:**
    - A lot of problems.. But no real improvement.

#### Nomystery-opt11-strips

- **Modifications:**
    - Single Goal: 
- **Notes:**
    - s

#### Rovers

- **Modifications:**
    - Single Goal: p01 - p03 
- **Notes:**
    - 

---

## Supported Domains

### Successfully Solved

- depot
- driverlog
- elevators-opt11-strips
- ged-opt14-strips
- gripper
- hiking-opt14-strips
- maintenance-opt14-adl
- miconic
- movie
- nomystery-opt11-strips
- pegsol-opt11-strips
- psr-small
- rovers
- satellite
- scanalyzer-opt11-strips
- storage
- tpp
- transport-opt14-strips
- trucks-strips
- zenotravel

### Error: Out of Memory

- airport
- barman-opt11-strips
- childsnacks-opt14-strips
- freecell
- grid
- mprime
- mystery
- no-mprime
- no-mystery
- pathways
- pathways-noneg
- pipesworld-notankage
- pipesworls-tankage
- schedule
- sokoban-opt11-strips
- tetris-opt14-strips
- thoughtful-mco14-strips
- tidybot-opt14-strips
- woodworking-opt11-strips

### Error: Out of Time

- blocks
- floortile-opt14-strips
- logistics00
- parcprinter-opt11-strips
- vistiall-opt14-strips

## Unsupported Domains

### Axioms

- assembly
- openstacks
- optical-telegraphs
- psr-middle
- trucks

### Conditional Effects

- citycar-opt14-adl

